#!perl -T

use Test::More;
use Data::Dumper;
use Geo::USCensus::Geocoding;
if ( $ENV{RELEASE_TESTING} ) {
  plan tests => 1;
  diag( "Testing lookup of a known nonexistent address" );
  my $result = Geo::USCensus::Geocoding->query(
    street  => '1000 Z St', # there is no Z street
    city    => 'Sacramento',
    state   => 'CA',
    zip     => '95814',
  );

  ok( !$result->is_match );
  diag( $result->content );
} else {
  plan skip_all => 'Set RELEASE_TESTING to run live tests.';
}
