BEGIN { $| = 1; print "1..1\n"; }

use Business::OnlinePayment;

my $tx = new Business::OnlinePayment("LinkPoint",
  'storename' => '1909922411',
  'keyfile'   => './test.pem',
);

$tx->content(
    type           => 'CHECK',
    action         => 'Normal Authorization',
    description    => 'Business::OnlinePayment::LinkPoint visa test',
    amount         => '0.01',
    first_name     => 'Tofu',
    last_name      => 'Beast',
    address        => '123 Anystreet',
    city           => 'Anywhere',
    state          => 'UT',
    zip            => '84058',
    country        => 'US',
    email          => 'ivan-linkpoint@420.am',
    account_number => '0027',
    account_type   => 'Personal Checking',
    routing_code   => '400700000',
    bank_name      => 'SomeBank',
    bank_state     => 'UT',
);

$tx->test_transaction(1);

$tx->submit();

if($tx->is_success()) {
    print "ok 1\n";
    $auth = $tx->authorization;
    warn "********* $auth ***********\n";
} else {
    print "not ok 1\n";
    warn '***** '. $tx->error_message. " *****\n";
    exit;
}

