#!perl

# Note: Place credentials for a TEST account in ./test_account file,
#       with login & password on separate lines.
#       See ./test_account_eg as example.

# As of 2012/12, this tests Void Purchase but not Void Return

use strict;
use Test::More;
require "t/lib/test_account.pl";
my ($merchant, $login, $password) = test_account_or_skip();
unless ($merchant && $login) {   #  && $password
   plan skip_all => 'You must specify your merchant ID, user name, & password';
}
plan tests => 5;
use constant DEBUG => 0;

use_ok 'Business::OnlinePayment';

my $hAlgm = 'MD5';  # if using hash validation
my $tx;
if ($merchant && $login && $password) {  # username & password
    $tx = Business::OnlinePayment->new('Beanstream',
				       merchant => $merchant);
    diag $merchant  if DEBUG>3;
    diag $login  if DEBUG>3;
} else {  # hash validation
    diag 'hash-validn'  if DEBUG>3;
    if (uc substr($login,0,5) eq 'SHA1:') {
      $password = substr($login,5);
      $hAlgm = 'SHA1';
    } else {
      if (uc substr($login,0,4) eq 'MD5:') {
        $password = substr($login,4);
      } else {
        $password = $login;  # implicitly MD5
      }
    }
    $login = $merchant;
    undef $merchant;  # for $refund_tx branch
    diag $login  if DEBUG>3;
    $tx = Business::OnlinePayment->new('Beanstream',
				       hash_algorithm => $hAlgm);
}


# Stage original purchase for testing Void
# avoid dup checking in case "make test" is run too close to the last run
my $amount = sprintf('%.2f', rand(10) + .5);
diag "Amount: $amount"  if DEBUG > 1;

$tx->content(
    login          => $login,
    password       => $password,
    action         => 'Normal Authorization',
    amount         => $amount,
    name           => 'Beanstream Tester',
    card_number    => '4030000010001234',
    expiration     => expiration_date(),
    address        => '123 Any Street',
    city           => 'Los Angeles',
    state          => 'CA',
    zip            => '23555',
    country        => 'US',
    phone          => '123-4567',
    email          => 'user@example.com',
);

# Account must in test mode, rather than counting on test_transaction()
$tx->test_transaction(1); # test, dont really charge

$tx->submit();

ok($tx->is_success(), 'Orig-Sale') or diag $tx->error_message;

my $auth = $tx->authorization;
my $order_number = $tx->order_number;
ok   $auth, 'authorization';
like $order_number, qr/^\d+$/, 'order number';

#warn "auth: $auth\n";
#warn "order_number: $order_number\n";

# Void the original transaction
my $refund_tx;
if ($merchant && $login && $password) {  # username & password
    $refund_tx = Business::OnlinePayment->new('Beanstream',
					      merchant => $merchant);
} else {  # hash validation
    $refund_tx = Business::OnlinePayment->new('Beanstream',
					      hash_algorithm => $hAlgm);
}
$refund_tx->content(
    login          => $login,
    password       => $password,
    action         => 'Void',
#   description    => 'Business::OnlinePayment visa test',
    amount         => $amount,
#   authorization  => $auth,
    order_number   => $order_number,
#   card_number    => '4030000010001234',
#   expiration     => expiration_date(),
#   name           => 'Beanstream Tester',
#   address        => '123 Any Street',
#   city           => 'Los Angeles',
#   state          => 'CA',
#   zip            => '23555',
#   country        => 'US',
#   phone          => '123-4567',
#   email          => 'user@example.com',
);

# Account must be in test mode, rather than counting on test_transaction()
$refund_tx->test_transaction(1); # test, dont really charge
$refund_tx->submit();

ok($refund_tx->is_success(), 'Void Purchase') or diag $refund_tx->error_message;
