#!perl

# Note: Place merchant-id for an account in TEST mode in ./test_account file .
#       See ./test_account_xm as example.
# If the Beanstream account is configured to require username & password,
# then skip this legacy test.

use strict;
use Test::More;
require "t/lib/test_account.pl";
my ($merchant, $login, $password) = test_account_or_skip();
if (!$merchant || $login || $password) {
   plan skip_all => 'Legacy test is for normal auth with merchant ID only.';
} else {
   $login = $merchant;
}
plan tests => 2;
use constant DEBUG => 0;

use Business::OnlinePayment;

# my $login = 'placeholder';  # Put your merchant ID here
#                             # Configure your merchant account in test mode.
# SKIP:   # skip attempts at connecting unless merchant ID specified
# {
#    if ($login eq 'placeholder')  {
#       skip('you must specify your merchant ID in order to connect', 2);
#    }

   my $trans = Business::OnlinePayment->new('Beanstream');

# 1. We will try to connect to beanstream server and post faked data.
#    Expect declined.

   $trans->content(
		   login          => $login,
		   action         => 'Normal Authorization',
		   amount         => '1.99',
#		   invoice_number => '56647',
#		   owner          => 'John Doe',
		   card_number    => '4003050500040005',
		   exp_date       => '12/12',
		   name           => 'Sam Shopper',
		   address        => '123 Any Street',
		   city           => 'Los Angeles',
		   state          => 'CA',
		   zip            => '23555',
		   country        => 'US',
		   phone          => '123-4567',
		   email          => 'Sam@shopper.com',
		   );

   $trans->submit();
   print STDERR $trans->error_message(),"\n" if DEBUG; 
   ok(!$trans->is_success);

# 2. We will try to connect to beanstream server and post a correct data.
#    Test transaction should succeed, with server in TEST mode.

#avoid dup checking in case "make test" is run too close to the last run
my $amount = sprintf('%.2f', rand(10));

   $trans->content(
		   login          => $login,
		   action         => 'Normal Authorization',
		   amount         => $amount,
#		   invoice_number => '56647',
#		   owner          => 'John Doe',
		   card_number    => '4030000010001234',
		   exp_date       => '12/12',
		   name           => 'Sam Shopper',
		   address        => '123 Any Street',
		   city           => 'Los Angeles',
		   state          => 'CA',
		   zip            => '23555',
		   country        => 'US',
		   phone          => '123-4567',
		   email          => 'Sam@shopper.com',
		   );

   $trans->submit();
   if (DEBUG){
      if ($trans->is_success) {
	 print STDERR "\n",$trans->authorization(),"\n"; 
      } else {
	 print STDERR "\n",$trans->error_message(),"\n"; 
      }
   }
   ok($trans->is_success);

#}
