# Create  t/test_account  with merchant_id, login, & password on separate lines,
# with your account in test mode, or developer sandbox account.
# Example: t/test_account_eg

# Adapted from BOP AuthorizeNet 3.20 via BOP E-xact

sub test_account_or_skip {
    my $suffix = shift;
    my ($merchant, $login, $password) = test_account($suffix);

    unless( defined $merchant ) {
        plan skip_all => "No test account";
    }

    return ($merchant, $login, $password);
}

sub test_account {
    my $suffix = shift || '';
    $suffix = "_$suffix" if $suffix;
    open TEST_ACCOUNT, "t/test_account$suffix" or return;
    my ($merchant, $login, $password) = <TEST_ACCOUNT>;
    chomp $merchant  if defined $merchant;
    chomp $login  if defined $login;
    chomp $password  if defined $password;
    close TEST_ACCOUNT;
    return ($merchant, $login, $password);
}

sub expiration_date {
    my($month, $year) = (localtime)[4,5];
    $month += 1;
    $year++;       # So we expire next year.
    $year %= 100;  # y2k?  What's that?

    return sprintf("%02d/%02d", $month, $year);
}

sub tomorrow {
    my($day, $month, $year) = (localtime(time+86400))[3..5];
    return sprintf("%04d-%02d-%02d", $year+1900, ++$month, $day);
}

1;
