#!/usr/bin/perl -w

#BEGIN {
#  $Net::HTTPS::Any::skip_NetSSLeay = 1;
#  $Net::HTTPS::Any::skip_NetSSLeay = 1;
#}

use Test::More;

require 't/lib/test_account.pl';
require Net::VoIP_Innovations;

my($login, $password) = test_account_or_skip();
plan tests => 1;

my $debug = $ENV{TEST_VERBOSE};

my $gp = Net::VoIP_Innovations->new( 'login'    => $login,
                                     'password' => $password,
                                     'sandbox'  => 1,
                                   );
my $return = $gp->getDIDs(
  'state'   => 'CA',
  #'lata'    => '722',
  #'npa'   => '415',
  #'lata' => '',
  #'rateCenter' => '',
  #'npa' => '',
  #'nxx' => '',
  #'tier' => '',
  #'t38' => '',
  #'cnam' => '',
);

#use Data::Dumper;
#diag( Dumper($return) );

#test some things about the return...
ok( $return->{responseCode} == 100, 'getDIDs returned no error' )
  or diag( $return->{responseMessage} );

