#!perl

# Note: Place merchant-id, username, & password for an account in TEST mode,
#       in ./test_account file.  See ./test_account_eg as example.
# If the account is not configured to require username & password, then
# merchant-id only will suffice (./test_account_xm).
# If the account is instead configured to require hash validation, then use
# merchant-id & hash-key (./test_account_xh).

use strict;
use Test::More;
require "t/lib/test_account.pl";
my ($merchant, $login, $password) = test_account_or_skip();
unless ($merchant) {  #  && $login && $password
   plan skip_all => 'You must specify your merchant ID, user name, & password';
}
plan tests => 2;
use constant DEBUG => 0;

use Business::OnlinePayment;

my $trans;      # !($login ^ $password)
if ($merchant && (($login && $password)           # username & password
		  || (!$login && !$password))) {  # merchant ID only
    $trans = Business::OnlinePayment->new('Beanstream',
					  merchant => $merchant);
    diag $merchant  if DEBUG>3;
    diag $login  if DEBUG>3;
} else {  #idea: hash validation
    $password = $login;  # hash-key
    $login = $merchant;  # merchant-id
    diag $login  if DEBUG>3;
    if (uc substr($password,0,5) eq 'SHA1:') {
      $password = substr($password,5);
      $trans = Business::OnlinePayment->new('Beanstream',
					    hash_algorithm => 'SHA1');
    } else {
      if (uc substr($password,0,4) eq 'MD5:') {
        $password = substr($password,4);
      }  # else implicitly MD5
      $trans = Business::OnlinePayment->new('Beanstream');
    }
}


# 1. We will try to connect to beanstream server and post faked data.
#    Expect declined.

my %content = (
    action         => 'Normal Authorization',
    amount         => '1.99',
#		   invoice_number => '56647',
    card_number    => '4003050500040005',
    expiration     => '12/12',
    name           => 'Sam Shopper',
    address        => '123 Any Street',
    city           => 'Los Angeles',
    state          => 'CA',
    zip            => '23555',
    country        => 'US',
    phone          => '123-4567',
    email          => 'Sam@shopper.com',
    );

# Case of merchant-ID only: do not pass login/password at all -
# should not error about missing required field.
$content{'login'} = $login  if defined $login;
$content{'password'} = $password  if defined $password;

$trans->content(%content);

$trans->submit();
print STDERR $trans->error_message(),"\n" if DEBUG; 
ok(!$trans->is_success);

# 2. We will try to connect to beanstream server and post a correct data.
#    Test transaction should succeed, with server in TEST mode.

#avoid dup checking in case "make test" is run too close to the last run
my $amount = sprintf('%.2f', rand(10));

$trans->content(
    login          => $login,
    password       => $password,
    action         => 'Normal Authorization',
    amount         => $amount,
#   invoice_number => '56647',
    card_number    => '4030000010001234',
    expiration     => expiration_date(),
    name           => 'Sam Shopper',
    address        => '123 Any Street',
    city           => 'Los Angeles',
    state          => 'CA',
    zip            => '23555',
    country        => 'US',
    phone          => '123-4567',
    email          => 'Sam@shopper.com',
    );

   $trans->submit();
   if (DEBUG){
      if ($trans->is_success) {
	 print STDERR "\n",$trans->authorization(),"\n"; 
      } else {
	 print STDERR "\n",$trans->error_message(),"\n"; 
      }
   }
   ok($trans->is_success);
