#!perl

# Note: Place credentials for a TEST account in ./test_account file,
#       with login & password on separate lines.
#       See ./test_account_eg as example.

use strict;
use Test::More;
require "t/lib/test_account.pl";
my ($merchant, $login, $password) = test_account_or_skip();
unless ($merchant && $login) {   #  && $password
   plan skip_all => 'You must specify your merchant ID, user name, & password';
}
plan tests => 5;
use constant DEBUG => 0;

use_ok 'Business::OnlinePayment';

#avoid dup checking in case "make test" is run too close to the last run
my $amount = sprintf('%.2f', rand(10) + .5);

my ($tx, $hAlgm);
if ($merchant && $login && $password) {  # username & password
    $tx = Business::OnlinePayment->new('Beanstream',
				       merchant => $merchant);
    diag $merchant  if DEBUG>3;
    diag $login  if DEBUG>3;
} else {  # hash validation
    diag 'hash-validn'  if DEBUG>3;
    if (uc substr($login,0,5) eq 'SHA1:') {
      $password = substr($login,5);
      $hAlgm = 'SHA1';
    } else {
      $hAlgm = 'MD5';
      if (uc substr($login,0,4) eq 'MD5:') {
        $password = substr($login,4);
      } else {
        $password = $login;  # implicitly MD5
      }
    }
    $login = $merchant;
    undef $merchant;  # for $refund_tx branch
    diag $login  if DEBUG>3;
    $tx = Business::OnlinePayment->new('Beanstream',
				       hash_algorithm => $hAlgm);
}


$tx->content(
    login          => $login,
    password       => $password,
    action         => 'Authorization Only',
    description    => 'Business::OnlinePayment visa test',
    amount         => $amount,
    owner          => 'John Doe',
    name           => 'Beanstream Tester',
    card_number    => '4030000010001234',
    expiration     => expiration_date(),
    address        => '123 Any Street',
    city           => 'Los Angeles',
    state          => 'CA',
    zip            => '23555',
    country        => 'US',
    phone          => '123-4567',
    email          => 'user@example.com',
);

# Account must in test mode, rather than counting on test_transaction()
$tx->test_transaction(1); # test, dont really charge

$tx->submit();

ok($tx->is_success(), 'Pre-Auth') or diag $tx->error_message;

my $auth = $tx->authorization;
my $order_number = $tx->order_number;
ok   $auth, 'authorization';
like $order_number, qr/^\d+$/, 'order number';

#warn "auth: $auth\n";
#warn "order_number: $order_number\n";

my $settle_tx;
if ($merchant && $login && $password) {  # username & password
    $settle_tx = Business::OnlinePayment->new('Beanstream',
					      merchant => $merchant);
} else {  # hash validation
    $settle_tx = Business::OnlinePayment->new('Beanstream',
					      hash_algorithm => $hAlgm);
}
$settle_tx->content(
    login          => $login,
    password       => $password,
    action         => 'Post Authorization',
    description    => 'Business::OnlinePayment visa test',
    amount         => $amount,
    authorization  => $auth,
    order_number   => $order_number,
    card_number    => '4030000010001234',
    expiration     => expiration_date(),
    owner          => 'John Doe',
    name           => 'Beanstream Tester',
    address        => '123 Any Street',
    city           => 'Los Angeles',
    state          => 'CA',
    zip            => '23555',
    country        => 'US',
    phone          => '123-4567',
    email          => 'user@example.com',
);

# Account must be in test mode, rather than counting on test_transaction()
$settle_tx->test_transaction(1); # test, dont really charge
$settle_tx->submit();

ok($settle_tx->is_success(), 'Capture') or diag $settle_tx->error_message;
