package Geo::USCensus::Geocoding::Result;

use Moo; # just for attribute declaration

has 'is_match' => ( is => 'rw', default => sub { 0 } );
foreach ( 'content',
          'match_level',
          'address',
          'state',
          'county',
          'tract',
          'block',
          'error_message',
          'latitude',
          'longitude'
        ) {
  has $_ => ( is => 'rw', default => sub { '' } );
}

sub censustract {
  my $self = shift;
  my $state = $self->state || '';
  my $county = $self->county || '';
  my $tract = $self->tract || '';

  if (length($state) and length($county) and length($tract)) {
    return $state.$county.$tract;
  } else {
    warn "tried to return census tract but fields are incomplete.
    state='$state', county='$county', tract='$tract'\n";
    return '';
  }
}

1;
