=head1 NAME

Business::BatchPayment::Batch

=head1 DESCRIPTION

A Business::BatchPayment::Batch object represents a group of payment 
requests or confirmations (L<Business::BatchPayment::Item>) submitted
to a bank (or returned from a bank) as a batch.

=head1 ATTRIBUTES

=over 4

=item incoming - Flag for one-way batches.  The processor must set
this if the batch was originated by the gateway.

=item batch_id - Batch identifier.  The format is processor-specific
but usually must be a positive integer, if it's used at all.

Processor modules may include C<batch_id> in a reply batch ONLY if 
it is guaranteed to match the batch_id of a request batch AND all 
the items in the reply batch come from that request batch.  Otherwise, 
C<batch_id> must be null.  It must always be null when using one-way
(receive-only) workflow, since there are no request batches.

=item items - An arrayref of L<Business::BatchPayment::Item> objects
included in the batch.

=back

=cut

package Business::BatchPayment::Batch;

use strict;
use Moose;

has incoming => (
  is => 'rw',
  isa => 'Bool',
);

has batch_id => (
  is => 'rw',
  isa => 'Str',
  default => '',
);

has items => (
  traits => ['Array'],
  is => 'rw',
  isa => 'ArrayRef[Business::BatchPayment::Item]',
  handles =>  {
    count     => 'count',
    elements  => 'elements',
    push      => 'push',
  },
  default => sub { [] },
);

1;
